/*
  Blend Tag
    あかつきみさき

  このスクリプトについて
    リストから合成モードを適用するスクリプト.

  使用方法
    1.ファイル→スクリプト→スクリプトファイルの実行から実行.
    2.ScriptUIフォルダに入れてから,ウィンドウより実行.

  動作保障環境
    Adobe After Effects 2024以上

  バージョン情報
    2025/12/30 Ver 1.1.0 Update
        Shift+クリックで,該当する合成モードのレイヤーを選択する機能を追加.

    2024/03/25 Ver 1.0.0 Release
*/

(function () {
    var data = {
        scriptName: "Blend Tag",
        scriptVersion: "1.1.0",
    }

    Settings.prototype.initSetting = function (sectionName, keyName, value) {
        if (!app.settings.haveSetting(sectionName, keyName)) {
            app.settings.saveSetting(sectionName, keyName, value);
        }
        return app.settings.getSetting(sectionName, keyName);
    };

    var SETTINGS_NORMAL = app.settings.initSetting(data.scriptName, "SETTINGS_NORMAL", 1);
    var SETTINGS_DISSOLVE = app.settings.initSetting(data.scriptName, "SETTINGS_DISSOLVE", 0);
    var SETTINGS_DANCING_DISSOLVE = app.settings.initSetting(data.scriptName, "SETTINGS_DANCING_DISSOLVE", 0);
    var SETTINGS_DARKEN = app.settings.initSetting(data.scriptName, "SETTINGS_DARKEN", 0);
    var SETTINGS_MULTIPLY = app.settings.initSetting(data.scriptName, "SETTINGS_MULTIPLY", 1);
    var SETTINGS_COLOR_BURN = app.settings.initSetting(data.scriptName, "SETTINGS_COLOR_BURN", 0);
    var SETTINGS_CLASSIC_COLOR_BURN = app.settings.initSetting(data.scriptName, "SETTINGS_CLASSIC_COLOR_BURN", 0);
    var SETTINGS_LINEAR_BURN = app.settings.initSetting(data.scriptName, "SETTINGS_LINEAR_BURN", 0);
    var SETTINGS_DARKER_COLOR = app.settings.initSetting(data.scriptName, "SETTINGS_DARKER_COLOR", 0);
    var SETTINGS_ADD = app.settings.initSetting(data.scriptName, "SETTINGS_ADD", 1);
    var SETTINGS_LIGHTEN = app.settings.initSetting(data.scriptName, "SETTINGS_LIGHTEN", 0);
    var SETTINGS_SCREEN = app.settings.initSetting(data.scriptName, "SETTINGS_SCREEN", 0);
    var SETTINGS_COLOR_DODGE = app.settings.initSetting(data.scriptName, "SETTINGS_COLOR_DODGE", 0);
    var SETTINGS_CLASSIC_COLOR_DODGE = app.settings.initSetting(data.scriptName, "SETTINGS_CLASSIC_COLOR_DODGE", 0);
    var SETTINGS_LINEAR_DODGE = app.settings.initSetting(data.scriptName, "SETTINGS_LINEAR_DODGE", 0);
    var SETTINGS_LIGHTER_COLOR = app.settings.initSetting(data.scriptName, "SETTINGS_LIGHTER_COLOR", 0);
    var SETTINGS_OVERLAY = app.settings.initSetting(data.scriptName, "SETTINGS_OVERLAY", 1);
    var SETTINGS_SOFT_LIGHT = app.settings.initSetting(data.scriptName, "SETTINGS_SOFT_LIGHT", 0);
    var SETTINGS_HARD_LIGHT = app.settings.initSetting(data.scriptName, "SETTINGS_HARD_LIGHT", 0);
    var SETTINGS_LINEAR_LIGHT = app.settings.initSetting(data.scriptName, "SETTINGS_LINEAR_LIGHT", 0);
    var SETTINGS_VIVID_LIGHT = app.settings.initSetting(data.scriptName, "SETTINGS_VIVID_LIGHT", 0);
    var SETTINGS_PIN_LIGHT = app.settings.initSetting(data.scriptName, "SETTINGS_PIN_LIGHT", 0);
    var SETTINGS_HARD_MIX = app.settings.initSetting(data.scriptName, "SETTINGS_HARD_MIX", 0);
    var SETTINGS_DIFFERENCE = app.settings.initSetting(data.scriptName, "SETTINGS_DIFFERENCE", 0);
    var SETTINGS_CLASSIC_DIFFERENCE = app.settings.initSetting(data.scriptName, "SETTINGS_CLASSIC_DIFFERENCE", 0);
    var SETTINGS_EXCLUSION = app.settings.initSetting(data.scriptName, "SETTINGS_EXCLUSION", 0);
    var SETTINGS_SUBTRACT = app.settings.initSetting(data.scriptName, "SETTINGS_SUBTRACT", 0);
    var SETTINGS_DIVIDE = app.settings.initSetting(data.scriptName, "SETTINGS_DIVIDE", 0);
    var SETTINGS_HUE = app.settings.initSetting(data.scriptName, "SETTINGS_HUE", 0);
    var SETTINGS_SATURATION = app.settings.initSetting(data.scriptName, "SETTINGS_SATURATION", 0);
    var SETTINGS_COLOR = app.settings.initSetting(data.scriptName, "SETTINGS_COLOR", 0);
    var SETTINGS_LUMINOSITY = app.settings.initSetting(data.scriptName, "SETTINGS_LUMINOSITY", 0);
    var SETTINGS_SILHOUETE_ALPHA = app.settings.initSetting(data.scriptName, "SETTINGS_SILHOUETE_ALPHA", 0);
    var SETTINGS_SILHOUETTE_LUMA = app.settings.initSetting(data.scriptName, "SETTINGS_SILHOUETTE_LUMA", 0);
    var SETTINGS_STENCIL_ALPHA = app.settings.initSetting(data.scriptName, "SETTINGS_STENCIL_ALPHA", 0);
    var SETTINGS_STENCIL_LUMA = app.settings.initSetting(data.scriptName, "SETTINGS_STENCIL_LUMA", 0);
    var SETTINGS_ALPHA_ADD = app.settings.initSetting(data.scriptName, "SETTINGS_ALPHA_ADD", 0);
    var SETTINGS_LUMINESCENT_PREMUL = app.settings.initSetting(data.scriptName, "SETTINGS_LUMINESCENT_PREMUL", 0);

    function buildUI(thisObj) {
        var btWin;
        if (thisObj instanceof Panel) {
            btWin = thisObj;
        } else {
            btWin = new Window("palette", data.scriptName, undefined, {
                resizeable: true
            });
        }

        btWin.orientation = "column";
        btWin.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.TOP];
        btWin.margins = [0, 0, 0, 0];
        btWin.spacing = 1;
        btWin.size = [400, 500];

        var listTp = btWin.add("group");
        listTp.margins = [0, 0, 0, 0];
        listTp.spacing = 0;
        listTp.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        listTp.orientation = "column";

        var bmTp = listTp.add("tabbedpanel");
        bmTp.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];

        var bmTab = bmTp.add("tab");
        bmTab.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        bmTab.text = localize({ en: "Blending Mode", ja: "合成モード" });

        var btnGrp = bmTab.add("group");
        btnGrp.margins = [0, 0, 0, 0];
        btnGrp.spacing = 3;
        btnGrp.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        btnGrp.orientation = "column";

        var settingTab = bmTp.add("tab");
        settingTab.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        settingTab.text = localize({ en: "Settings", ja: "リスト設定" });

        var modeLb = settingTab.add("listbox");
        modeLb.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];

        var modeList = [
            { ja: "通常", en: "Normal", blendingModeText: BlendingMode.NORMAL, setting: "SETTINGS_NORMAL" },
            { ja: "ディザ合成", en: "Dissolve", blendingModeText: BlendingMode.DISSOLVE, setting: "SETTINGS_DISSOLVE" },
            { ja: "ダイナミックディザ合成", en: "Dancing Dissolve", blendingModeText: BlendingMode.DANCING_DISSOLVE, setting: "SETTINGS_DANCING_DISSOLVE" },
            { ja: "比較（暗）", en: "Darken", blendingModeText: BlendingMode.DARKEN, setting: "SETTINGS_DARKEN" },
            { ja: "乗算", en: "Multiply", blendingModeText: BlendingMode.MULTIPLY, setting: "SETTINGS_MULTIPLY" },
            { ja: "焼き込みカラー", en: "Color Burn", blendingModeText: BlendingMode.COLOR_BURN, setting: "SETTINGS_COLOR_BURN" },
            { ja: "焼き込みカラー（クラシック）", en: "Classic Color Burn", blendingModeText: BlendingMode.CLASSIC_COLOR_BURN, setting: "SETTINGS_CLASSIC_COLOR_BURN" },
            { ja: "焼き込みリニア", en: "Linear Burn", blendingModeText: BlendingMode.LINEAR_BURN, setting: "SETTINGS_LINEAR_BURN" },
            { ja: "カラー比較（暗）", en: "Darker Color", blendingModeText: BlendingMode.DARKER_COLOR, setting: "SETTINGS_DARKER_COLOR" },
            { ja: "加算", en: "Add", blendingModeText: BlendingMode.ADD, setting: "SETTINGS_ADD" },
            { ja: "比較（明）", en: "Lighten", blendingModeText: BlendingMode.LIGHTEN, setting: "SETTINGS_LIGHTEN" },
            { ja: "スクリーン", en: "Screen", blendingModeText: BlendingMode.SCREEN, setting: "SETTINGS_SCREEN" },
            { ja: "覆い焼きカラー", en: "Color Dodge", blendingModeText: BlendingMode.COLOR_DODGE, setting: "SETTINGS_COLOR_DODGE" },
            { ja: "覆い焼きカラー（クラシック）", en: "Classic Color Dodge", blendingModeText: BlendingMode.CLASSIC_COLOR_DODGE, setting: "SETTINGS_CLASSIC_COLOR_DODGE" },
            { ja: "覆い焼きリニア", en: "Linear Dodge", blendingModeText: BlendingMode.LINEAR_DODGE, setting: "SETTINGS_LINEAR_DODGE" },
            { ja: "カラー比較（明）", en: "Lighter Color", blendingModeText: BlendingMode.LIGHTER_COLOR, setting: "SETTINGS_LIGHTER_COLOR" },
            { ja: "オーバーレイ", en: "Overlay", blendingModeText: BlendingMode.OVERLAY, setting: "SETTINGS_OVERLAY" },
            { ja: "ソフトライト", en: "Soft Light", blendingModeText: BlendingMode.SOFT_LIGHT, setting: "SETTINGS_SOFT_LIGHT" },
            { ja: "ハードライト", en: "Hard Light", blendingModeText: BlendingMode.HARD_LIGHT, setting: "SETTINGS_HARD_LIGHT" },
            { ja: "リニアライト", en: "Linear Light", blendingModeText: BlendingMode.LINEAR_LIGHT, setting: "SETTINGS_LINEAR_LIGHT" },
            { ja: "ビビッドライト", en: "Vivid Light", blendingModeText: BlendingMode.VIVID_LIGHT, setting: "SETTINGS_VIVID_LIGHT" },
            { ja: "ピンライト", en: "Pin Light", blendingModeText: BlendingMode.PIN_LIGHT, setting: "SETTINGS_PIN_LIGHT" },
            { ja: "ハードミックス", en: "Hard Mix", blendingModeText: BlendingMode.HARD_MIX, setting: "SETTINGS_HARD_MIX" },
            { ja: "差", en: "Difference", blendingModeText: BlendingMode.DIFFERENCE, setting: "SETTINGS_DIFFERENCE" },
            { ja: "差（クラシック）", en: "Classic Difference", blendingModeText: BlendingMode.CLASSIC_DIFFERENCE, setting: "SETTINGS_CLASSIC_DIFFERENCE" },
            { ja: "除外", en: "Exclusion", blendingModeText: BlendingMode.EXCLUSION, setting: "SETTINGS_EXCLUSION" },
            { ja: "減算", en: "Subtract", blendingModeText: BlendingMode.SUBTRACT, setting: "SETTINGS_SUBTRACT" },
            { ja: "除算", en: "Divide", blendingModeText: BlendingMode.DIVIDE, setting: "SETTINGS_DIVIDE" },
            { ja: "色相", en: "Hue", blendingModeText: BlendingMode.HUE, setting: "SETTINGS_HUE" },
            { ja: "彩度", en: "Saturation", blendingModeText: BlendingMode.SATURATION, setting: "SETTINGS_SATURATION" },
            { ja: "カラー", en: "Color", blendingModeText: BlendingMode.COLOR, setting: "SETTINGS_COLOR" },
            { ja: "輝度", en: "Luminosity", blendingModeText: BlendingMode.LUMINOSITY, setting: "SETTINGS_LUMINOSITY" },
            { ja: "ステンシルアルファ", en: "Stencil Alpha", blendingModeText: BlendingMode.SILHOUETE_ALPHA, setting: "SETTINGS_SILHOUETE_ALPHA" },
            { ja: "ステンシルルミナンス", en: "Stencil Luma", blendingModeText: BlendingMode.SILHOUETTE_LUMA, setting: "SETTINGS_SILHOUETTE_LUMA" },
            { ja: "シルエットアルファ", en: "Silhouette Alpha", blendingModeText: BlendingMode.STENCIL_ALPHA, setting: "SETTINGS_STENCIL_ALPHA" },
            { ja: "シルエットルミナンス", en: "Silhouette Luma", blendingModeText: BlendingMode.STENCIL_LUMA, setting: "SETTINGS_STENCIL_LUMA" },
            { ja: "アルファ追加", en: "Alpha Add", blendingModeText: BlendingMode.ALPHA_ADD, setting: "SETTINGS_ALPHA_ADD" },
            { ja: "ルミナンスプリマルチプライ", en: "Luminescent Premul", blendingModeText: BlendingMode.LUMINESCENT_PREMUL, setting: "SETTINGS_LUMINESCENT_PREMUL" }
        ];

        for (var i = 0; i < modeList.length; i++) {
            var tempItem = modeLb.add("item", localize({
                en: modeList[i].en,
                ja: modeList[i].ja,
            }));
            tempItem.checked = Boolean(Number(app.settings.getSetting(data.scriptName, modeList[i].setting)));
            tempItem.blendingModeText = modeList[i].blendingModeText;
            tempItem.setting = modeList[i].setting;
        }

        function setBlendingMode(mode) {
            var actComp = app.project.activeItem;
            if (!(actComp instanceof CompItem)) {
                return 0;
            }

            var selLayers = actComp.selectedLayers;
            app.beginUndoGroup(data.scriptName);
            for (var j = 0; j < selLayers.length; j++) {
                selLayers[j].blendingMode = mode;
            }
            app.endUndoGroup();
        }

        function selectLayersWithMode(mode) {
            var actComp = app.project.activeItem;
            if (!(actComp instanceof CompItem)) {
                return 0;
            }

            app.beginUndoGroup(data.scriptName);
            for (var i = 1; i <= actComp.numLayers; i++) {
                var curLayer = actComp.layer(i);
                if (!curLayer.blendingMode) {
                    curLayer.selected = false;
                    continue;
                }

                curLayer.selected = (curLayer.blendingMode == mode);
            }
            app.endUndoGroup();
        }

        var btnList = [];
        bmTp.onChange = function () {
            try {
                bmTab.remove(btnGrp);

                btnGrp = bmTab.add("group");
                btnGrp.margins = [0, 0, 0, 0];
                btnGrp.spacing = 3;
                btnGrp.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
                btnGrp.orientation = "column";

                btnList = [];

                for (var i = 0; i < modeLb.items.length; i++) {
                    if (!modeLb.items[i].checked) {
                        continue;
                    };

                    btnList[btnList.length] = btnGrp.add("button");
                    btnList[btnList.length - 1].alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
                    btnList[btnList.length - 1].text = modeLb.items[i].text;
                    btnList[btnList.length - 1].blendingModeText = modeLb.items[i].blendingModeText;
                    btnList[btnList.length - 1].helpTip = "";
                    btnList[btnList.length - 1].onClick = function () {
                        var keyState = ScriptUI.environment.keyboardState;
                        if (keyState.shiftKey) {
                            selectLayersWithMode(this.blendingModeText);
                            return;
                        }

                        setBlendingMode(this.blendingModeText);
                    };
                }

                if (btnList.length == 0) {
                    var noBtnSt = btnGrp.add("statictext");
                    noBtnSt.text = localize({ en: "No items", ja: "リストが設定されていません" });
                    noBtnSt.alignment = [ScriptUI.Alignment.CENTER, ScriptUI.Alignment.FILL];
                }

                btWin.layout.layout(true);
                btWin.layout.resize();
            } catch (err) { }
        }

        modeLb.onChange = function () {
            if (this.selection == null) {
                return 0;
            }

            this.selection.checked = !this.selection.checked;
            app.settings.saveSetting(data.scriptName, this.selection.setting, Number(this.selection.checked));
            this.selection = null;
        }

        for (var i = 0; i < modeLb.items.length; i++) {
            if (!modeLb.items[i].checked) {
                continue;
            };

            btnList[btnList.length] = btnGrp.add("button");
            btnList[btnList.length - 1].alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
            btnList[btnList.length - 1].text = modeLb.items[i].text;
            btnList[btnList.length - 1].blendingModeText = modeLb.items[i].blendingModeText;
            btnList[btnList.length - 1].helpTip = "";
            btnList[btnList.length - 1].onClick = function () {
                var keyState = ScriptUI.environment.keyboardState;
                if (keyState.shiftKey) {
                    selectLayersWithMode(this.blendingModeText);
                    return;
                }

                setBlendingMode(this.blendingModeText);
            };
        }

        var creditTab = bmTp.add("tab");
        creditTab.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        creditTab.text = "?";

        var helpGrp = creditTab.add("group");
        helpGrp.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.FILL];
        helpGrp.orientation = "column";

        var helpSt = helpGrp.add("statictext");
        helpSt.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.TOP];
        helpSt.text = data.scriptName + " " + data.scriptVersion;

        var helpSt2 = helpGrp.add("statictext");
        helpSt2.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.TOP];
        helpSt2.text = "あかつきみさき";

        var helpEt = helpGrp.add("edittext", undefined, undefined, { readonly: true });
        helpEt.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.TOP];
        helpEt.text = "https://sunrisemoon.net/";

        var textSt = helpGrp.add("statictext", undefined, undefined, { multiline: true });
        textSt.alignment = [ScriptUI.Alignment.FILL, ScriptUI.Alignment.TOP];
        textSt.text = "「合成モード」\nクリック：該当する合成モードを選択しているレイヤーに適用\nShift+クリック：該当する合成モードのレイヤーを選択\n\n「リスト設定」\nボタン表示する合成モードを設定";

        btWin.layout.layout(true);
        btWin.onResizing = btWin.onResize = function () {
            this.layout.resize();
        }

        if (!(thisObj instanceof Panel)) {
            btWin.center();
            btWin.show();
        }

        return 0;
    }

    buildUI(this);

    return 0;
}).call(this);